<?php
if ( defined( 'WPB_VC_VERSION' ) ) {
	class WPBakeryShortCode_sm_multi_scroll_section extends WPBakeryShortCodesContainer {
		function content($atts, $content = null) {
			return sm_multi_scroll_section_func( $atts, $content );
		}
	}
} else {
	add_shortcode( 'sm_multi_scroll_section', 'sm_multi_scroll_section_func' );
}

function sm_multi_scroll_section_func( $atts, $content = "" ) {
	$view_params = array(
		'atts' => $atts,
		'content' => $content
	);
	return sm_render_view( 'multi-scroll-section', $view_params );
}

add_action( 'vc_before_init', 'vc_map_sm_multi_scroll_section' );
function vc_map_sm_multi_scroll_section() {
	vc_map( array(
		'name' => esc_html__( 'Multi Scroll Section', 'semona-extension' ),
		'base' => 'sm_multi_scroll_section',
		'icon' => SM_PLUGIN_URL . '/assets/images/shortcodes/icon-multi_scroll_section.png',
		'category' => esc_html__( 'by Theme-Paradise', 'semona-extension' ),
		'description' => esc_html__( 'Multi-scrolling container with split screen', 'semona-extension' ),
		'as_child' => array( 'only' => 'sm_multi_scroll_left_side, sm_multi_scroll_right_side' ),
		'allowed_container_element' => 'vc_row',
		'content_element' => true,
		'is_container' => true,
		'js_view' => 'VcColumnView',
		'params' => array(
			array(
				'type' => 'el_id',
				'heading' => esc_html__( 'Section ID', 'semona-extension' ),
				'param_name' => 'el_id',
				'description' => sprintf( __ ( 'Enter section ID. That ID can be used for onepage navigation. Make sure it is unique and valid as specified in the <a target="_blank" href="%s">W3C standard</a> (Must not have spaces)', 'semona-extension' ), 'http://www.w3schools.com/tags/att_global_id.asp' ),
			),
			sm_extra_class(),
			sm_css_box_option(),
		),
	) );
}
