<?php



function sm_register_shortcode_handler_sm_message() {

	if ( defined( 'WPB_VC_VERSION' ) ) {

		require_once vc_path_dir( 'SHORTCODES_DIR', 'vc-message.php' );

		class WPBakeryShortCode_sm_message extends WPBakeryShortCode_VC_message {

			function content($atts, $content = null) {

				return sm_message_func( $atts, $content );

			}

		}

	} else {

		add_shortcode( 'sm_message', 'sm_message_func' );

	}

}



function sm_message_func( $atts, $content = "" ) {

	$view_params = array(

		'atts' => $atts,

		'content' => $content

	);

	return sm_render_view( 'message', $view_params );

}



sm_register_shortcode( array (

	'name' => esc_html__( 'Message Box', 'semona-extension' ),

	'base' => 'sm_message',

	'category' => esc_html__( 'by Theme-Paradise', 'semona-extension' ),

	'description' => esc_html__( 'Notification box', 'semona-extension' ),

	'icon' => SM_PLUGIN_URL . '/assets/images/shortcodes/icon-messagebox.png',

	'params' => array_merge(

		array(

			array(

				'type' => 'textfield',

				'holder' => 'div',

				'class' => 'text',

				'heading' => esc_html__( 'Message title', 'semona-extension' ),

				'param_name' => 'title',

				'value' => esc_html__( 'Message Title', 'semona-extension' )

			),

			array(

				'type' => 'textarea',

				'holder' => 'div',

				'class' => 'text',

				'heading' => esc_html__( 'Message content', 'semona-extension' ),

				'param_name' => 'content',

				'value' => esc_html__( 'Your message comes here!', 'semona-extension' )

			),

			array(

				'type' => 'dropdown',

				'heading' => esc_html__( 'Style', 'semona-extension' ),

				'param_name' => 'style',

				'value' => sm_get_message_styles_array(),

				'description' => esc_html__( 'Select message box design style.', 'semona-extension' ),

				'edit_field_class' => 'vc_col-sm-6 vc_column',

			),

			array(

				'type' => 'dropdown',

				'heading' => esc_html__( 'Size', 'semona-extension' ),

				'param_name' => 'size',

				'value' => sm_get_message_sizes_array(),

				'description' => esc_html__( 'Select message box size.', 'semona-extension' ),

				'edit_field_class' => 'vc_col-sm-6 vc_column',

			),

			array(

				'type' => 'dropdown',

				'heading' => esc_html__( 'Message Box Type', 'semona-extension' ),

				'param_name' => 'type', // due to backward compatibility, really it is message_box_type

				'value' => sm_get_message_types_array(),

				'description' => esc_html__( 'Select predefined message box design or choose "Custom" for custom styling.', 'semona-extension' ),

				'param_holder_class' => 'sm-preset-color-dropdown',

			),

		),

		sm_get_icon_options_array( '', false, 

			array(

				'element' => 'type',

				'value' => 'custom'

			)

		),

		array(

			array(

				'type' => 'dropdown',

				'heading' => esc_html__( 'Color', 'semona-extension' ),

				'param_name' => 'color',

				'value' => sm_get_message_colors_array(),

				'description' => esc_html__( 'Select message box color.', 'semona-extension' ),

				'param_holder_class' => 'sm-preset-color-dropdown',

				'dependency' => array(

					'element' => 'type',

					'value' => 'custom'

				)

			),

			sm_extra_class()

		)

	),

	'js_view' => 'SMMessageView'

) );



