<?php



function sm_logo_func( $atts, $content ) {

	extract( shortcode_atts( array(

			'skin' => 'lightbg',

			'align' => '',

			'margin_bottom' => ''

	), $atts ) );

	

	if( function_exists( 'sm_output_logo' ) ) {

		ob_start();

		$id = sm_shortcode_unique_id( "sm_logo" );

		echo "<div id='" . esc_attr( $id ) . "' class='sm-sc-logo'>";

		echo "<style scoped>";

		if( $margin_bottom ) {

			$margin_bottom = sm_validate_length_unit( $margin_bottom );

			echo ".sm-sc-logo#{$id} .logo-wrapper{ margin-bottom:{$margin_bottom}; }";

		}

		if( $align ) {

			echo ".sm-sc-logo#{$id} .logo-wrapper{ text-align:" . esc_attr( $align ) . "; }";

		}

		echo "</style>";

		$skin = sm_validate_with_array( $skin, sm_get_logo_skins_array() );

		if (function_exists( 'sm_output_logo' ) ) {

			if( $skin == 'darkbg' ) {

				sm_output_logo( 'dark' );

			} else {

				sm_output_logo( 'light' );

			}

		}

		echo "</div>";

		$output = ob_get_contents();

		ob_get_clean();

		

		return $output;

	} else {

		return '';

	}

}



sm_register_shortcode( array (

	'name' => esc_html__( 'Logo', 'semona-extension' ),

	'base' => 'sm_logo',

	//'icon' => SM_PLUGIN_URL . '/assets/images/shortcodes/icon-logo.png',

	'params' => array(

		array(

			'type' => 'dropdown',

			'heading' => esc_html__( 'Logo Skin', 'semona-extension' ),

			'param_name' => 'skin',

			'value' => sm_get_logo_skins_array(),

			'description' => esc_html__( 'Choose Logo Underlying Background Skin', 'semona-extension' )

		),

		array(

				'type' => 'dropdown',

				'heading' => esc_html__( 'Logo Align', 'semona-extension' ),

				'param_name' => 'align',

				'value' =>  array(

					esc_html__( 'Default', 'semona-extension' ) => '',

					esc_html__( 'Left', 'semona-extension' ) => 'left',

					esc_html__( 'Center', 'semona-extension' ) => 'center',

					esc_html__( 'Right', 'semona-extension' ) => 'right',

				),

		),

		array(

			'type' => 'textfield',

			'heading' => esc_html__( 'Margin Bottom', 'semona-extension' ),

			'param_name' => 'margin_bottom',

			'description' => esc_html__( 'Leave blank to use default. (Note: CSS measurement units allowed.)', 'semona-extension' ),

		),

	)

) );

