<?php



function sm_register_shortcode_handler_sm_image_carousel() {

	if ( defined( 'WPB_VC_VERSION' ) ) {

		class WPBakeryShortCode_sm_image_carousel extends WPBakeryShortCode {

			function content($atts, $content = null) {

				return sm_image_carousel_func( $atts, $content );

			}

		}

	} else {

		add_shortcode( 'sm_image_carousel', 'sm_image_carousel_func' );

	}

}



function sm_image_carousel_func( $atts, $content = null ) {

	extract( shortcode_atts ( 

		array_merge( array (

			'images' => '',

			'items' => '5',

			'autoplay' => '',

			'item_spacing' => '',

			'lightbox' => '',

			'v_padding' => '',

			'show_nav' => 'yes',

			'show_bullets_nav' => '',

			'nav_color' => '',

			'nav_bullet_color' => '',

			'bullet_margin_top' => '',

			'el_class' => '',

		), sm_get_bg_shortcode_atts()

	), $atts ) );

	

	$bg_url = '';

	if ( !empty( $bg_img ) ) {

		$bg_url = wp_get_attachment_image_src( $bg_img, 'full' );

		if ( $bg_url !== false ) $bg_url = $bg_url[0];

	}



	$id = sm_shortcode_unique_id( 'sm-image-carousel' );

	$css_gen = new Inline_CSS_Generator( 'sm-image-carousel', $id );

	$css_class = '';

	$scoped_css = '';



	if ( 'sm-style-gradient' == $bg_style ) {

		if ( $grad_color1 != 'custom' ) {

			$custom_grad_color1 = sm_get_color_code_by_name( $grad_color1 );

		}

		if ( $grad_color2 != 'custom' ) {

			$custom_grad_color2 = sm_get_color_code_by_name( $grad_color2 );

		}



		$angle = intval( $angle );



		$scoped_css .= '#' . $id . '.sm-image-carousel{';

		$scoped_css .= sm_get_bg_img_gradient_css( $custom_grad_color1, $custom_grad_color2, $angle, $bg_url);

		$scoped_css .= '}';

	} else if ( 'sm-style-def-grad1' == $bg_style || 'sm-style-def-grad2' == $bg_style ) {

		$css_class .= ' ' . $bg_style;

	} else {

		$css_parts = '';

		if ( $bg_color == 'custom' ) {

			$css_parts .= 'background-color:' . $custom_bg_color .';';

		} else {

			$css_class .= ' ' . $bg_color;

		}

		$css_parts .= sm_get_bg_img_css( $bg_url );

		if ( $css_parts != '' ) {

			$scoped_css .= '#' . $id . '.sm-image-carousel{' . $css_parts . '}';

		}

	}

	if ( 'yes' == $show_nav ) {

		$css_class .= ' show-nav';

		if ( !empty( $nav_color ) ) {

			$scoped_css .= $css_gen->css( 

				array( '.carousel-control:before', '.carousel-control:after' ),

				array( 'border-color' => $nav_color )

			);

		}

	}



	if ( 'yes' == $show_bullets_nav ) {

		if ( !empty( $nav_bullet_color ) ) {

			$scoped_css .= $css_gen->css( 

				array( '.bullet-controls a' ),

				array( 'background-color' => $nav_bullet_color )

			);

		}

		if ( $bullet_margin_top != '' ) {

			$bullet_margin_top = sm_validate_length_unit( $bullet_margin_top );

			$scoped_css .= $css_gen->css( 

				array( '.bullet-controls' ),

				array( 'margin-top' => $bullet_margin_top )

			);

		}

	}



	$autoplay = sm_validate_with_array( $autoplay, sm_get_autoplay_intervals_array() );

	$css_class .= sm_get_extra_class( $el_class );



	if ( $v_padding != '' ) {

		$v_padding = sm_validate_length_unit( $v_padding );

		$scoped_css .= $css_gen->css( '', array( 'padding-top' => $v_padding, 'padding-bottom' => $v_padding ) );

	}



	if ( $item_spacing != '' ) {

		$item_spacing = intval( $item_spacing ) / 2;

		$scoped_css .= $css_gen->css( 'li', array( 'padding' => '0 ' . $item_spacing . 'px !important' ) );

	}



	$view_params = array(

		'id' => $id,

		'scoped_css' => $scoped_css,

		'classes' => $css_class,

		'images' => $images,

		'items' => $items,

		'autoplay' => $autoplay,

		'show_nav' => $show_nav,

		'show_bullets_nav' => $show_bullets_nav,

		'lightbox' => $lightbox

	);



	return sm_render_view( 'image-carousel', $view_params );

}



sm_register_shortcode( array (

	'name' => esc_html__( 'Image Carousel', 'semona-extension' ),

	'base' => 'sm_image_carousel',

	'category' =>  esc_html__( 'by Theme-Paradise', 'semona-extension' ),

	'icon' => SM_PLUGIN_URL . '/assets/images/shortcodes/icon-image_carousel.png',

	'params' => array_merge(

		array (

			array(

				'type' => 'attach_images',

				'heading' => esc_html__( 'Images', 'semona-extension' ),

				'param_name' => 'images',

			),

			array(

				'type' => 'textfield',

				'heading' => esc_html__( 'Maximum Items visible', 'semona-extension' ),

				'param_name' => 'items',

				'value' => '5',

				'edit_field_class' => 'vc_col-sm-6 vc_column',

			),

			array(

				'type' => 'dropdown',

				'heading' => esc_html__( 'Autoplay', 'semona-extension' ),

				'param_name' => 'autoplay',

				'value' => sm_get_autoplay_intervals_array(),

				'edit_field_class' => 'vc_col-sm-6 vc_column',

			),

			array(

				'type' => 'textfield',

				'heading' => esc_html__( 'Vertical Padding', 'semona-extension' ),

				'param_name' => 'v_padding',

				'value' => '',

				'description' => esc_html__( 'Specify vertical padding(px). Leave blank to use default padding value(95px).', 'semona-extension' ),

				'edit_field_class' => 'vc_col-sm-6 vc_column',

			),

			array (

				'type' => 'textfield',

				'heading' => esc_html__( 'Item Spacing', 'semona-extension' ),

				'param_name' => 'item_spacing',

				'value' => '',

				'description' => esc_html__( 'Specify value for spacing between image in px. Leave blank to use default value(20px).', 'semona-extension' ),

				'edit_field_class' => 'vc_col-sm-6 vc_column',

			),

			array(

				'type' => 'checkbox',

				'heading' => esc_html__( 'Show Lightbox', 'semona-extension' ),

				'param_name' => 'lightbox',

				'value' => array( esc_html__( 'Yes', 'semona-extension' ) => 'yes' ),

				'description' => esc_html__( 'Put checkmark to show lightbox on image click.', 'semona-extension' ),

			),

			array(

				'type' => 'checkbox',

				'heading' => esc_html__( 'Show Navigation Arrows', 'semona-extension' ),

				'param_name' => 'show_nav',

				'value' => array( esc_html__( 'Yes', 'semona-extension' ) => 'yes' ),

				'std' => 'yes',

			),

			array(

				'type' => 'colorpicker',

				'heading' => esc_html__( 'Navigation Arrow Color', 'semona-extension' ),

				'param_name' => 'nav_color',

				'description' => esc_html__( 'Choose navigation control color.', 'semona-extension' ),

				'edit_field_class' => 'vc_col-sm-6 vc_column',

				'dependency' => array(

					'element' => 'show_nav',

					'value' => 'yes',

				),

			),

			array(

				'type' => 'checkbox',

				'heading' => esc_html__( 'Show Navigation Bullets', 'semona-extension' ),

				'param_name' => 'show_bullets_nav',

				'value' => array( esc_html__( 'Yes', 'semona-extension' ) => 'yes' ),

			),

			array(

				'type' => 'colorpicker',

				'heading' => esc_html__( 'Navigation Bullets Color', 'semona-extension' ),

				'param_name' => 'nav_bullet_color',

				'description' => esc_html__( 'Choose navigation control color.', 'semona-extension' ),

				'edit_field_class' => 'vc_col-sm-6 vc_column',

				'dependency' => array(

					'element' => 'show_bullets_nav',

					'value' => 'yes',

				),

			),

			array (

				'type' => 'textfield',

				'heading' => esc_html__( 'Bullets Top Margin', 'semona-extension' ),

				'param_name' => 'bullet_margin_top',

				'value' => '',

				'description' => esc_html__( 'Specify the space between bullets and carousel(px).', 'semona-extension' ),

				'edit_field_class' => 'vc_col-sm-6 vc_column',

				'dependency' => array(

					'element' => 'show_bullets_nav',

					'value' => 'yes',

				),

			),

			sm_extra_class(),

		), sm_get_background_options_array()

	)

) );

