<?php



function sm_register_shortcode_handler_sm_empty_space() {

	if ( defined( 'WPB_VC_VERSION' ) ) {

		class WPBakeryShortCode_sm_empty_space extends WPBakeryShortCode {

			function content($atts, $content = null) {

				return sm_empty_space_func( $atts, $content );

			}

		}

	} else {

		add_shortcode( 'sm_empty_space', 'sm_empty_space_func' );

	}

}



function sm_empty_space_func( $atts, $content = "" ) {

	$view_params = array(

		'atts' => $atts,

		'content' => $content

	);

	return sm_render_view( 'empty-space', $view_params );

}



sm_register_shortcode( array (

	'name' => esc_html__( 'Empty Space', 'semona-extension' ),

	'base' => 'sm_empty_space',

	'category' => esc_html__( 'by Theme-Paradise', 'semona-extension' ),

	'description' => esc_html__( 'Blank space with custom height', 'semona-extension' ),

	'icon' => SM_PLUGIN_URL . '/assets/images/shortcodes/icon-empty_space.png',

	'params' => array(

		array(

			'type' => 'textfield',

			'heading' => esc_html__( 'Height', 'semona-extension' ),

			'param_name' => 'height',

			'value' => '35px',

			'admin_label' => true,

			'description' => esc_html__( 'Enter empty space height (Note: CSS measurement units allowed).', 'semona-extension' ),

		),

		sm_extra_class()

	),

) );

