<?php



function sm_register_shortcode_handler_sm_counterbox() {

	if ( defined( 'WPB_VC_VERSION' ) ) {

		class WPBakeryShortCode_sm_counterbox extends WPBakeryShortCode {

			function content($atts, $content = null) {

				return sm_counterbox_func( $atts, $content );

			}

		}

	} else {

		add_shortcode( 'sm_counterbox', 'sm_counterbox_func' );

	}

}



function sm_counterbox_func( $atts, $content = '' ) {

	$view_params = array(

		'atts' => $atts,

		'content' => $content

	);

	return sm_render_view( 'counterbox', $view_params );

}



sm_register_shortcode( array (

	'name' => esc_html__( 'Counter Box', 'semona-extension' ),

	'base' => 'sm_counterbox',

	'category' => esc_html__( 'by Theme-Paradise', 'semona-extension' ),

	'description' => esc_html__( 'Counter Box', 'semona-extension' ),

	'icon' => SM_PLUGIN_URL . '/assets/images/shortcodes/icon-counterbox.png',

	'params' => array_merge(

		array(

			array (

				'type' => 'dropdown',

				'heading' => esc_html__( 'Style', 'semona-extension' ),

				'param_name' => 'style',

				'value' => sm_get_counterbox_styles_array(),

				'admin_label' => true,

				'description' => esc_html__( 'Select counter box style.', 'semona-extension' ),

			),

			array (

				'type' => 'textfield',

				'heading' => esc_html__( 'Counter Value', 'semona-extension' ),

				'param_name' => 'value',

				'value' => '',

				'admin_label' => true,

				'description' => esc_html__( 'Specify the value to count up to.', 'semona-extension' ),

			),

			array (

				'type' => 'textfield',

				'heading' => esc_html__( 'Prefix', 'semona-extension' ),

				'param_name' => 'prefix',

				'value' => '',

				'edit_field_class' => 'vc_col-sm-6 vc_column',

				'description' => esc_html__( 'Short prefix string. (ex. currency symbol)', 'semona-extension' ),

				'dependency' => array(

					'element' => 'style',

					'value_not_equal_to' => array( 'sm-style-flip', 'sm-style-number' ),

				),

			),

			array (

				'type' => 'textfield',

				'heading' => esc_html__( 'Suffix', 'semona-extension' ),

				'param_name' => 'suffix',

				'value' => '',

				'edit_field_class' => 'vc_col-sm-6 vc_column',

				'description' => esc_html__( 'Short suffix string. (ex. %)', 'semona-extension' ),

				'dependency' => array(

					'element' => 'style',

					'value_not_equal_to' => array( 'sm-style-flip', 'sm-style-number' ),

				),

			),

			array (

				'type' => 'textfield',

				'heading' => esc_html__( 'Text', 'semona-extension' ),

				'param_name' => 'text',

				'value' => '',

				'admin_label' => true,

				'dependency' => array(

					'element' => 'style',

					'value_not_equal_to' => array( 'sm-style-number' ),

				),

			),

		),

		sm_get_icon_options_array( '', false, array(

			'element' => 'style',

			'value_not_equal_to' => array( 'sm-style-flip', 'sm-style-number' ),

		) ),

		array(

			array(

				'type' => 'colorpicker',

				'heading' => esc_html__( 'Custom Color', 'semona-extension' ),

				'param_name' => 'color',

				'description' => esc_html__( 'Select custom color. (Leave blank to use default)', 'semona-extension' ),

				'edit_field_class' => 'vc_col-sm-6 vc_column',

			),

			array(

				'type' => 'dropdown',

				'heading' => esc_html__( 'Alignment', 'semona-extension' ),

				'param_name' => 'align',

				'value' => sm_get_default_aligns_array(),

				'description' => esc_html__( 'Select counter box alignment.', 'semona-extension' ),

				'dependency' => array(

					'element' => 'style',

					'value' => array( 'sm-style-flip', 'sm-style-number' ),

				),

				'edit_field_class' => 'vc_col-sm-6 vc_column',

			),

			array(

				'type' => 'dropdown',

				'heading' => esc_html__( 'Number Font Size', 'semona-extension' ),

				'param_name' => 'number_font_size',

				'value' => sm_get_counterbox_font_sizes_array(),

				'description' => esc_html__( 'Select counter box number font size.', 'semona-extension' ),

				'dependency' => array(

					'element' => 'style',

					'value' => 'sm-style-number',

				),

			),

			sm_css_animation_class(),

			sm_css_animation_delay(),

			sm_extra_class()

		)

	),

) );