<?php



function sm_register_shortcode_handler_sm_contact_info() {

	if ( defined( 'WPB_VC_VERSION' ) ) {

		class WPBakeryShortCode_sm_contact_info extends WPBakeryShortCode {

			function content($atts, $content = null) {

				return sm_contact_info_func( $atts, $content );

			}

		}

	} else {

		add_shortcode( 'sm_contact_info', 'sm_contact_info_func' );

	}

}



function sm_contact_info_func( $atts, $content = "" ) {

	$view_params = array(

		'atts' => $atts,

		'content' => $content

	);

	return sm_render_view( 'contact-info', $view_params );

}



sm_register_shortcode( array (

	'name' => esc_html__( 'Contact Info Field', 'semona-extension' ),

	'base' => 'sm_contact_info',

	'category' => esc_html__( 'by Theme-Paradise', 'semona-extension' ),

	'description' => esc_html__( 'Contact Info Field', 'semona-extension' ),

	'icon' => SM_PLUGIN_URL . '/assets/images/shortcodes/icon-contact_info.png',

	'params' => array(

		array (

			'type' => 'textfield',

			'heading' => esc_html__( 'Field Label', 'semona-extension' ),

			'param_name' => 'field',

			'admin_label' => true,

		),

		array (

			'type' => 'textarea',

			'heading' => esc_html__( 'Field Value', 'semona-extension' ),

			'param_name' => 'value',

			'admin_label' => true,

		),

		array (

			'type' => 'colorpicker',

			'heading' => esc_html__( 'Label Color', 'semona-extension' ),

			'param_name' => 'field_color',

		),

		array (

			'type' => 'dropdown',

			'heading' => esc_html__( 'Value Color Style', 'semona-extension' ),

			'param_name' => 'value_color_style',

			'value' => sm_get_contact_info_color_styles_array(),

		),

		array (

			'type' => 'colorpicker',

			'heading' => esc_html__( 'Value Color', 'semona-extension' ),

			'param_name' => 'value_color',

			'dependency' => array(

				'element' => 'value_color_style',

				'value' => array( 'sm-style-solid' )

			),

		),

		array (

			'type' => 'colorpicker',

			'heading' => esc_html__( 'Border Color', 'semona-extension' ),

			'param_name' => 'border_color',

			'description' => esc_html__( 'Leave blank to use default border color.', 'semona-extension' )

		),

		sm_css_animation_class(),

		sm_css_animation_delay(),

		sm_extra_class()

	),

) );