<?php



function sm_callout_func( $atts, $content = "" ) {

	$view_params = array(

		'atts' => $atts,

		'content' => $content

	);

	return sm_render_view( 'callout', $view_params );

}



function sm_register_shortcode_handler_sm_callout() {

	if ( defined( 'WPB_VC_VERSION' ) ) {

		class WPBakeryShortCode_sm_callout extends WPBakeryShortCode {

			function content($atts, $content = null) {

				return sm_callout_func( $atts, $content );

			}

		}

	} else {

		add_shortcode( 'sm_callout', 'sm_callout_func' );

	}

}



sm_register_shortcode( array (

	'name' => esc_html__( 'Callout', 'semona-extension' ),

	'base' => 'sm_callout',

	'category' => esc_html__( 'by Theme-Paradise', 'semona-extension' ),

	'icon' => SM_PLUGIN_URL . '/assets/images/shortcodes/icon-callout.png',

	'params' => array_merge(

		array (

			array (

				'type' => 'textfield',

				'heading' => esc_html__( 'Heading', 'semona-extension' ),

				'param_name' => 'heading',

				'value' => esc_html__( 'Heading Text', 'semona-extension' ),

				'admin_label' => true

			),

			array (

				'type' => 'textfield',

				'heading' => esc_html__( 'Sub Heading', 'semona-extension' ),

				'param_name' => 'sub_heading',

				'admin_label' => true

			),

			array(

				'type' => 'checkbox',

				'heading' => esc_html__( 'Uppercase', 'semona-extension' ),

				'param_name' => 'uppercase',

				'value' => array( esc_html__( 'Yes', 'semona-extension' ) => 'yes' ),

				'description' => esc_html__( 'Put checkmark if you want to show Heading and Sub heading in uppercase.', 'semona-extension' )

			),

			array (

				'type' => 'dropdown',

				'heading' => esc_html__( 'Show Button', 'semona-extension' ),

				'param_name' => 'btn_pos',

				'value' => sm_get_callout_btn_pos_array(),

				'group' => esc_html__( 'Button', 'semona-extension' ),

			),

			array (

				'type' => 'dropdown',

				'heading' => esc_html__( 'Button Style', 'semona-extension' ),

				'param_name' => 'btn_style',

				'value' => sm_get_callout_btn_styles_array(),

				'group' => esc_html__( 'Button', 'semona-extension' ),

				'dependency' => array(

					'element' => 'btn_pos',

					'not_empty' => true,

				),

			),

			array (

				'type' => 'textfield',

				'heading' => esc_html__( 'Button Label', 'semona-extension' ),

				'param_name' => 'btn_label',

				'admin_label' => false,

				'dependency' => array(

					'element' => 'btn_pos',

					'not_empty' => true,

				),

				'group' => esc_html__( 'Button', 'semona-extension' ),

			),

			array (

				'type' => 'textfield',

				'heading' => esc_html__( 'Button Link', 'semona-extension' ),

				'param_name' => 'btn_link',

				'admin_label' => false,

				'dependency' => array(

					'element' => 'btn_pos',

					'value' => array( 'right', 'bottom' ),

				),

				'group' => esc_html__( 'Button', 'semona-extension' ),

				'edit_field_class' => 'vc_col-sm-8 vc_column',

			),

			array(

				'type' => 'checkbox',

				'heading' => esc_html__( 'Open in New Window', 'semona-extension' ),

				'param_name' => 'open_new',

				'dependency' => array(

					'element' => 'btn_pos',

					'not_empty' => true,

				),

				'group' => esc_html__( 'Button', 'semona-extension' ),

				'edit_field_class' => 'vc_col-sm-4 vc_column',

			),

			sm_extra_class()

		), sm_get_background_options_array()

	)

) );