<?php



function sm_button_func( $atts, $content = "" ) {

	$view_params = array(

		'atts' => $atts,

		'content' => $content

	);

	return sm_render_view( 'button', $view_params );

}



function sm_register_shortcode_handler_sm_button() {

	if ( defined( 'WPB_VC_VERSION' ) ) {

		class WPBakeryShortCode_sm_button extends WPBakeryShortCode {

			function content($atts, $content = null) {

				return sm_button_func( $atts, $content );

			}

		}

	} else {

		add_shortcode( 'sm_button', 'sm_button_func' );

	}

}



sm_register_shortcode( array (

	'name' => esc_html__( 'Button', 'semona-extension' ),

	'base' => 'sm_button',

	'category' => esc_html__( 'by Theme-Paradise', 'semona-extension' ),

	'icon' => SM_PLUGIN_URL . '/assets/images/shortcodes/icon-button.png',

	'params' => array_merge(

		array (

			array (

				'type' => 'textfield',

				'heading' => esc_html__( 'Caption', 'semona-extension' ),

				'param_name' => 'content',

				'value' => esc_html__( 'Button', 'semona-extension' ),

			),

			array(

				'type' => 'textfield',

				'heading' => esc_html__( 'URL (Link)', 'semona-extension' ),

				'param_name' => 'link',

				'description' => esc_html__( 'Add link to button.', 'semona-extension' ),

			),



			array(

				'type' => 'checkbox',

				'heading' => esc_html__( 'Uppercase', 'semona-extension' ),

				'param_name' => 'uppercase',

				'edit_field_class' => 'vc_col-sm-4 vc_column',

			),

			array(

				'type' => 'checkbox',

				'heading' => esc_html__( 'Open in New Window', 'semona-extension' ),

				'param_name' => 'open_new',

				'edit_field_class' => 'vc_col-sm-8 vc_column',

			),

			

			array(

				'type' => 'dropdown',

				'heading' => esc_html__( 'Shape', 'semona-extension' ),

				'description' => esc_html__( 'Select button shape.', 'semona-extension' ),

				'param_name' => 'shape',

				'value' => sm_get_button_shapes_array(),

				'edit_field_class' => 'vc_col-sm-4 vc_column',

			),

			

			array(

				'type' => 'dropdown',

				'heading' => esc_html__( 'Size', 'semona-extension' ),

				'param_name' => 'size',

				'description' => esc_html__( 'Select button display size.', 'semona-extension' ),

				'value' => sm_get_button_sizes_array(),

				'edit_field_class' => 'vc_col-sm-4 vc_column',

			),

			array(

				'type' => 'dropdown',

				'heading' => esc_html__( 'Alignment', 'semona-extension' ),

				'param_name' => 'align',

				'description' => esc_html__( 'Select button alignment.', 'semona-extension' ),

				'value' => sm_get_button_aligns_array(),

				'edit_field_class' => 'vc_col-sm-4 vc_column',

			),

			array(

				'type' => 'dropdown',

				'heading' => esc_html__( 'Style', 'semona-extension' ),

				'description' => esc_html__( 'Select button display style.', 'semona-extension' ),

				'param_name' => 'style',

				'value' => sm_get_button_styles_array(),

			),

			array(

				'type' => 'dropdown',

				'heading' => esc_html__( 'Border Width', 'semona-extension' ),

				'param_name' => 'border_width',

				'description' => esc_html__( 'Select border width.', 'semona-extension' ),

				'value' => sm_get_button_border_widths_array(),

				'dependency' => array(

					'element' => 'style',

					'value' => array( 'sm-style-outline' )

				),

			),

			array(

				'type' => 'checkbox',

				'heading' => esc_html__( 'Translucent', 'semona-extension' ),

				'param_name' => 'translucent',

				'description' => esc_html__( 'Put checkmark to display translucent button.', 'semona-extension' ),

				'dependency' => array(

					'element' => 'style',

					'value' => array( 'sm-style-white' )

				),

			),



			array(

				'type' => 'dropdown',

				'heading' => esc_html__( 'Main Button Color', 'semona-extension' ),

				'param_name' => 'color',

				'description' => esc_html__( 'Select main button color.', 'semona-extension' ),

				'param_holder_class' => 'sm-preset-color-dropdown',

				'value' => sm_get_preset_colors_array( true ),

				'dependency' => array(

					'element' => 'style',

					'value_not_equal_to' => array( 'sm-style-def-grad1', 'sm-style-def-grad2', 'sm-style-gradient' )

				),

				'group' => esc_html__( 'Colors', 'semona-extension' ),

			),

			array(

				'type' => 'colorpicker',

				'heading' => esc_html__( 'Custom Button Color', 'semona-extension' ),

				'param_name' => 'custom_color',

				'description' => esc_html__( 'Select custom button main color.', 'semona-extension' ),

				'dependency' => array(

					'element' => 'color',

					'value' => array( 'custom' )

				),

				'group' => esc_html__( 'Colors', 'semona-extension' ),

			),



			array(

				'type' => 'dropdown',

				'heading' => esc_html__( 'Gradient Color 1', 'semona-extension' ),

				'param_name' => 'grad_color1',

				'description' => esc_html__( 'Select background gradient start color for your button.', 'semona-extension' ),

				'param_holder_class' => 'sm-preset-color-dropdown',

				'value' => sm_get_preset_colors_array( true ),

				'dependency' => array(

					'element' => 'style',

					'value' => array( 'sm-style-gradient' )

				),

				'group' => esc_html__( 'Colors', 'semona-extension' ),

			),

			array(

				'type' => 'colorpicker',

				'heading' => esc_html__( 'Custom Gradient Color 1', 'semona-extension' ),

				'param_name' => 'custom_grad_color1',

				'description' => esc_html__( 'Select custom background gradient start color for your button.', 'semona-extension' ),

				'dependency' => array(

					'element' => 'grad_color1',

					'value' => array( 'custom' )

				),

				'group' => esc_html__( 'Colors', 'semona-extension' ),

			),



			array(

				'type' => 'dropdown',

				'heading' => esc_html__( 'Gradient Color 2', 'semona-extension' ),

				'param_name' => 'grad_color2',

				'description' => esc_html__( 'Select background gradient end color for your button.', 'semona-extension' ),

				'param_holder_class' => 'sm-preset-color-dropdown',

				'value' => sm_get_preset_colors_array( true ),

				'dependency' => array(

					'element' => 'style',

					'value' => array( 'sm-style-gradient' )

				),

				'group' => esc_html__( 'Colors', 'semona-extension' ),

			),

			array(

				'type' => 'colorpicker',

				'heading' => esc_html__( 'Custom Gradient Color 2', 'semona-extension' ),

				'param_name' => 'custom_grad_color2',

				'description' => esc_html__( 'Select custom background gradient end color for your button', 'semona-extension' ),

				'dependency' => array(

					'element' => 'grad_color2',

					'value' => array( 'custom' )

				),

				'group' => esc_html__( 'Colors', 'semona-extension' ),

			),



			array (

				'type' => 'textfield',

				'heading' => esc_html__( 'Angle', 'semona-extension' ),

				'param_name' => 'angle',

				'description' => esc_html__( 'Specify an angle between 0 - 360.', 'semona-extension' ),

				'dependency' => array(

					'element' => 'style',

					'value' => array( 'sm-style-gradient' )

				),

				'group' => esc_html__( 'Colors', 'semona-extension' ),

			),



			array(

				'type' => 'colorpicker',

				'heading' => esc_html__( 'Custom Text Color', 'semona-extension' ),

				'param_name' => 'text_color',

				'description' => esc_html__( 'Select custom text color for your button. Leave blank to use default.', 'semona-extension' ),

				'dependency' => array(

					'element' => 'style',

					'value_not_equal_to' => array( 'sm-style-white' )

				),

				'group' => esc_html__( 'Colors', 'semona-extension' ),

			),

			sm_css_animation_class(),

			sm_css_animation_delay(),

			sm_extra_class()

		),

		sm_get_icon_options_array( esc_html__( 'Icons', 'semona-extension' ), true ),

		array(

			array(

				'type' => 'dropdown',

				'heading' => esc_html__( 'Icon Position', 'semona-extension' ),

				'description' => esc_html__( 'Choose icon position.', 'semona-extension' ),

				'param_name' => 'i_align',

				'value' => array(

					esc_html__( 'Left', 'semona-extension' ) => 'left',

					esc_html__( 'Right', 'semona-extension' ) => 'right',

				),

				'dependency' => array(

					'element' => 'icon_type',

					'not_empty' => true,

				),

				'group' => esc_html__( 'Icons', 'semona-extension' ),

			),				

		)

	),

	'js_view' => 'SMButtonView',

	'custom_markup' => '<div class="sm-button-container"><button class="sm-button {{ params.shape }} {{ params.style }} {{ params.color }}">{{{ params.content }}}</button></div>',

) );