<?php



function sm_accordion_tab_func( $atts, $content = "" ) {

	$view_params = array(

		'atts' => $atts,

		'content' => $content

	);

	return sm_render_view( 'accordion-tab', $view_params );

}



function sm_register_shortcode_handler_sm_accordion_tab() {

	if ( defined( 'WPB_VC_VERSION' ) ) {

		require_once vc_path_dir( 'SHORTCODES_DIR', 'vc-column.php' );

		require_once vc_path_dir( 'SHORTCODES_DIR', 'vc-tab.php' );

		require_once vc_path_dir( 'SHORTCODES_DIR', 'vc-accordion-tab.php' );

		class WPBakeryShortCode_SM_Accordion_tab extends WPBakeryShortCode_VC_Accordion_tab {

			function content($atts, $content = null) {

				return sm_accordion_tab_func( $atts, $content );

			}

		}

	} else {

		add_shortcode( 'sm_accordion_tab', 'sm_accordion_tab_func' );

	}

}



sm_register_shortcode( array (

	'name' => esc_html__( 'Accordion Tab', 'semona-extension' ),

	'base' => 'sm_accordion_tab',

	'allowed_container_element' => 'vc_row',

	'is_container' => true,

	'content_element' => false,

	'icon' => SM_PLUGIN_URL . '/assets/images/shortcodes/icon-accordion_tab.png',

	'params' => array(

		array(

			'type' => 'textfield',

			'heading' => esc_html__( 'Title', 'semona-extension' ),

			'param_name' => 'title',

			'description' => esc_html__( 'Enter accordion section title.', 'semona-extension' )

		),

		array(

			'type' => 'el_id',

			'heading' => esc_html__( 'Section ID', 'semona-extension' ),

			'param_name' => 'el_id',

			'description' => sprintf( esc_html__( 'Enter optionally row ID. Make sure it is unique, and it is valid as w3c specification: %s (Must not have spaces)', 'semona-extension' ), '<a target="_blank" href="http://www.w3schools.com/tags/att_global_id.asp">' . esc_html__( 'link', 'semona-extension' ) . '</a>' ),

		),

	),

	'js_view' => 'SMAccordionTabView'

) );