<?php



add_action ( 'widgets_init', 'sm_load_widget_tweets' );



function sm_load_widget_tweets() {

	register_widget ( 'Semona_Tweets_Widget' );

}



class Semona_Tweets_Widget extends WP_Widget {

	

	function __construct() {

		$id_base = 'sm-widget-tweets';

		$widget_opts = array (

				'classname' => 'sm-widget-tweets',

				'description' => '' 

		);

		$control_opts = array (

				'id_base' => $id_base 

		);

		parent::__construct( $id_base, esc_html__( 'Semona: Twitter', 'semona-extension' ), $widget_opts, $control_opts );

	}

	function widget($args, $instance) {

		extract ( $args );

		$title = apply_filters ( 'widget_title', $instance ['title'] );

		$consumer_key = $instance['consumer_key'];

		$consumer_secret = $instance['consumer_secret'];

		$access_token = $instance['access_token'];

		$access_token_secret = $instance['access_token_secret'];

		$twitter_id = $instance['twitter_id'];

		$count = ( int ) $instance['count'];

		$widget_id = $args['widget_id'];

		

		echo ( $before_widget );

		

		if ($title) {

			echo ( $before_title . $title . $after_title );

		}

		

		do_action( 'sm_before_widget_twitter', $instance );

		

		if ($twitter_id && $consumer_key && $consumer_secret && $access_token && $access_token_secret && $count) {

			$transName = 'list_tweets_' . $widget_id;

			$cacheTime = 10;

			if (false === ($twitterData = get_transient ( $transName ))) {

				$twitterConnection = new TwitterOAuth( $consumer_key, $consumer_secret, $access_token, $access_token_secret );

				$twitterData = $twitterConnection->get( 'statuses/user_timeline', array(

						'screen_name'     => $twitter_id,

						'count'           => $count,

						'exclude_replies' => false

				) );

				if($twitterConnection->http_code != 200) {

					$twitterData = get_transient($transName);

				}

				set_transient($transName, $twitterData, 60 * $cacheTime);

			}

			$twitter = get_transient($transName);

			if( $twitter && is_array ( $twitter ) ) {

				$tweets = 0; 

				?>

				<div class="sm-tweets"> 

				<?php foreach($twitter as $tweet):

					$tweets++;

					if( $tweets > $count ) {

						break;

					} ?>

				<div class="sm-tweet-container">

					<div class="twitter-icon">

						<i class='fa fa-twitter'></i>

					</div>

					<div class='contents'>

						<div class='desc'><?php

									$latestTweet = $tweet->text;

									$latestTweet = preg_replace ( '/https:\/\/([a-z0-9_\.\-\+\&\!\#\~\/\,]+)/i', '<a href="https://$1" target="_blank">https://$1</a>&nbsp;', $latestTweet );

									$latestTweet = preg_replace ( '/http:\/\/([a-z0-9_\.\-\+\&\!\#\~\/\,]+)/i', '<a href="https://$1" target="_blank">https://$1</a>&nbsp;', $latestTweet );

									$latestTweet = preg_replace ( '/@([a-z0-9_]+)/i', '&nbsp;<a href="http://twitter.com/$1" target="_blank">@$1</a>&nbsp;', $latestTweet );

									echo ( $latestTweet );

									?></div>

						<div class='date'><?php

									$twitterTime = strtotime ( $tweet->created_at );

									$timeAgo = $this->ago ( $twitterTime );

									?>

							<a href="https://twitter.com/<?php echo esc_attr( $tweet->user->screen_name ); ?>/statuses/<?php echo esc_attr( $tweet->id_str ); ?>"

								class="jtwt_date"><?php echo ( $timeAgo ); ?></a>

						</div>

					</div>

				</div>

				<?php endforeach; ?>

				</div>

				<?php

			} 

		}

		

		do_action( 'sm_after_widget_twitter', $instance );

		

		echo ( $after_widget );

	}

	function ago($time) {

		$periods = array (

				esc_html__( 'second', 'semona-extension' ),

				esc_html__( 'minute', 'semona-extension' ),

				esc_html__( 'hour', 'semona-extension' ),

				esc_html__( 'day', 'semona-extension' ),

				esc_html__( 'week', 'semona-extension' ),

				esc_html__( 'month', 'semona-extension' ),

				esc_html__( 'year', 'semona-extension' ),

				esc_html__( 'decade', 'semona-extension' ) 

		);

		$periods_plural = array (

				esc_html__( 'seconds', 'semona-extension' ),

				esc_html__( 'minutes', 'semona-extension' ),

				esc_html__( 'hours', 'semona-extension' ),

				esc_html__( 'days', 'semona-extension' ),

				esc_html__( 'weeks', 'semona-extension' ),

				esc_html__( 'months', 'semona-extension' ),

				esc_html__( 'years', 'semona-extension' ),

				esc_html__( 'decades', 'semona-extension' ) 

		);

		$lengths = array (

				'60',

				'60',

				'24',

				'7',

				'4.35',

				'12',

				'10' 

		);

		$now = time ();

		$difference = $now - $time;

		$tense = esc_html__( 'ago', 'semona-extension' );

		

		for($j = 0; $difference >= $lengths [$j] && $j < count ( $lengths ) - 1; $j ++) {

			$difference /= $lengths [$j];

		}

		

		$difference = round ( $difference );

		

		if ($difference != 1) {

			$periods [$j] = $periods_plural [$j];

		}

		

		return sprintf ( '%s %s %s', $difference, $periods [$j], $tense );

	}

	function update($new_instance, $old_instance) {

		$instance = $old_instance;

		

		$instance ['title'] = sm_do_kses( $new_instance ['title'] );

		$instance ['consumer_key'] = $new_instance['consumer_key'];

		$instance ['consumer_secret'] = $new_instance['consumer_secret'];

		$instance ['access_token'] = $new_instance['access_token'];

		$instance ['access_token_secret'] = $new_instance['access_token_secret'];

		$instance ['twitter_id'] = $new_instance['twitter_id'];

		$instance ['count'] = $new_instance['count'];

		

		return $instance;

	}

	function form($instance) {

		$defaults = array (

				'title' => esc_html__( 'Latest Tweets', 'semona-extension' ),

				'twitter_id' => '',

				'count' => 3,

				'consumer_key' => '',

				'consumer_secret' => '',

				'access_token' => '',

				'access_token_secret' => '' 

		);

		$instance = wp_parse_args ( ( array ) $instance, $defaults );

		?>

	<p>

	<label for="<?php echo esc_attr( $this->get_field_id('title') ); ?>"><?php echo esc_html__( 'Title', 'semona-extension' ) ?>:</label>

	<input class="widefat" type="text"

		id="<?php echo esc_attr( $this->get_field_id('title') ); ?>"

		name="<?php echo esc_attr( $this->get_field_name('title') ); ?>"

		value="<?php echo esc_attr( $instance['title'] ); ?>" />

	</p>



	<p>

	<label for="<?php echo esc_attr( $this->get_field_id('consumer_key') ); ?>"><?php echo esc_html__( "Consumer Key", 'semona-extension' ) ?>:</label>

	<input class="widefat" type="text"

		id="<?php echo esc_attr( $this->get_field_id('consumer_key') ); ?>"

		name="<?php echo esc_attr( $this->get_field_name('consumer_key') ); ?>"

		value="<?php echo esc_attr( $instance['consumer_key'] ); ?>" />

	</p>



	<p>

	<label for="<?php echo esc_attr( $this->get_field_id('consumer_secret') ); ?>"><?php echo esc_html__( "Consumer Secret", 'semona-extension' ) ?>:</label>

	<input class="widefat" type="text"

		id="<?php echo esc_attr( $this->get_field_id('consumer_secret') ); ?>"

		name="<?php echo esc_attr( $this->get_field_name('consumer_secret') ); ?>"

		value="<?php echo esc_attr( $instance['consumer_secret'] ); ?>" />

	</p>



	<p>

	<label for="<?php echo esc_attr( $this->get_field_id('access_token') ); ?>"><?php echo esc_html__( "Access Token", 'semona-extension' ) ?>:</label>

	<input class="widefat" type="text"

		id="<?php echo esc_attr( $this->get_field_id('access_token') ); ?>"

		name="<?php echo esc_attr( $this->get_field_name('access_token') ); ?>"

		value="<?php echo esc_attr( $instance['access_token'] ); ?>" />

	</p>



	<p>

	<label for="<?php echo esc_attr( $this->get_field_id('access_token_secret') ); ?>"><?php echo esc_html__( "Access Token Secret", 'semona-extension' ) ?>:</label>

	<input class="widefat" type="text"

		id="<?php echo esc_attr( $this->get_field_id('access_token_secret') ); ?>"

		name="<?php echo esc_attr( $this->get_field_name('access_token_secret') ); ?>"

		value="<?php echo esc_attr( $instance['access_token_secret'] ); ?>" />

	</p>



	<p>

	<label for="<?php echo esc_attr( $this->get_field_id('twitter_id') ); ?>"><?php echo esc_html__( "Twitter Username", 'semona-extension' ) ?>:</label>

	<input class="widefat" type="text"

		id="<?php echo esc_attr( $this->get_field_id('twitter_id') ); ?>"

		name="<?php echo esc_attr( $this->get_field_name('twitter_id') ); ?>"

		value="<?php echo esc_attr( $instance['twitter_id'] ); ?>" />

	</p>



	<p>

	<label for="<?php echo esc_attr( $this->get_field_id('count') ); ?>"><?php echo esc_html__( "Number of Tweets", 'semona-extension' ) ?>:</label>

	<input class="widefat" type="text"

		id="<?php echo esc_attr( $this->get_field_id('count') ); ?>"

		name="<?php echo esc_attr( $this->get_field_name('count') ); ?>"

		value="<?php echo esc_attr( $instance['count'] ); ?>" />

	</p>



	<?php

	}

}

