<?php



add_action ( 'widgets_init', 'sm_load_contact_info' );



function sm_load_contact_info() {

	register_widget ( 'Semona_Contact_Info_Widget' );

}



class Semona_Contact_Info_Widget extends WP_Widget {

	

	function __construct() {

		$id_base = 'sm-widget-contact-info';

		$widget_opts = array (

				'classname' => 'sm-widget-contact-info',

				'description' => '' 

		);

		$control_opts = array (

				'id_base' => $id_base 

		);

		parent::__construct( $id_base, esc_html__( 'Semona: Contact Info', 'semona-extension' ), $widget_opts, $control_opts );

	}

	function widget($args, $instance) {

		extract ( $args );

		$title = apply_filters ( 'widget_title', $instance ['title'] );

		$widget_id = $args['widget_id'];

		

		echo ( $before_widget );

		

		if ($title) {

			echo ( $before_title . $title . $after_title );

		}

		

		

		echo ( $after_widget );

	}



	function get_type_array() {

		return array(

			'icon' => esc_Html__( 'Icon', 'semona-extension' ),

			'text' => esc_Html__( 'Text', 'semona-extension' ),

		);

	}

	function get_contact_field_format_array() {

		return array(

			'' => array(

				'label' => esc_Html__( 'None', 'semona-extension' ),

				'icon' => 'pe-7s-map-marker',

			),

			'address' => array(

				'label' => esc_Html__( 'Address', 'semona-extension' ),

				'icon' => 'pe-7s-map-marker',

			),

			'phone' => array(

				'label' => esc_Html__( 'Phone', 'semona-extension' ),

				'icon' => 'pe-7s-phone',

			),

			'email' => array(

				'label' => esc_Html__( 'Email', 'semona-extension' ),

				'icon' => 'pe-7s-mail',

			),

			'hours' => array(

				'label' => esc_Html__( 'Work Hours', 'semona-extension' ),

				'icon' => 'pe-7s-clock',

			),

			'other' => array(

				'label' => esc_Html__( 'Other', 'semona-extension' ),

				'icon' => 'pe-7s-file',

			),

		);

	}



	function validate_fields( $fields ) {

		if( is_array( $fields ) ) {

			foreach( $fields as $field ) {

				$field['title'] = crf_do_kses( $field['title'] );

				$field['format'] = crf_do_kses( $field['format'] );

				$field['content'] = crf_do_kses( $field['content'] );

			}

			unset( $field );

			return $fields;

		}

		return array();

	}



	function update($new_instance, $old_instance) {

		$instance = $old_instance;

		

		$instance['title'] = sm_do_kses( $new_instance ['title'] );

		$instance['type'] = sm_do_kses( $new_instance ['type'] );

		$instance['fields'] = $this->validate_fields( $new_instance['fields'] );

		

		return $instance;

	}



	function form($instance) {

		$defaults = array (

				'title' => esc_html__( 'Contact Info', 'semona-extension' ),

				'type' => 'icon',

				'fields' => array(), 

		);



		$instance = wp_parse_args( ( array ) $instance, $defaults );



		wp_enqueue_script( 'jquery-ui-sortable' );

		wp_enqueue_script( 'crf-widgets' );

		?>

		<p>

			<label for="<?php echo esc_attr( $this->get_field_id('title') ); ?>"><?php echo esc_html__( "Title", 'semona-extension' ) ?>:</label>

			<input class="widefat" type="text" id="<?php echo esc_attr( $this->get_field_id('title') ); ?>" name="<?php echo esc_attr( $this->get_field_name('title') ); ?>" value="<?php echo esc_attr( $instance['title'] ); ?>" />

		</p>



		<p>

			<label for="<?php echo esc_attr( $this->get_field_id('type') ); ?>"><?php echo esc_html__( "Field Type", 'semona-extension' ) ?>:</label>

			<select class="widefat" id="<?php echo esc_attr( $this->get_field_id('type') ); ?>" name="<?php echo esc_attr( $this->get_field_name('type') ); ?>">

			<?php foreach( $this->get_type_array() as $k => $v ) : ?>

				<option value="<?php echo esc_attr( $k ); ?>"<?php if ( $k == $instance['type'] ) : ?> selected="selected"<?php endif; ?>><?php echo esc_html( $v ); ?></option>

			<?php endforeach; ?>

			</select>

		</p>



		<div class="add-sortable-container">

			<a href='#' class="button button-primary crf-btn-add-accordion-tab"><?php _e( 'Add Field', 'semona-extension' ) ?></a>

		</div>

		<div class="crf-new-handle" data-field-name="<?php echo esc_attr( $this->get_field_name('fields') ) . "[*index]"; ?>">

			<div class="crf-widget-accordion-tab crf-sortable-handle ui-sortable-handle">

				<div class="accordion-tab-title crf-sortable-handle-title">

					<?php _e( 'Field', 'semona-extension' ) ?>: <span><?php _e( 'address', 'semona-extension' ) ?></span>

					<div class='delete'><i class='fa fa-close'></i></div>

					<div class='open'><i class='fa fa-caret-down'></i></div>

				</div>

				<div class="crf-sortable-content-wrapper">

					<p>

						<label for="<?php echo esc_attr( $this->get_field_id('fields') ) . "[data-index]"; ?>[format]"><?php echo esc_html__( "Field Format", 'semona-extension' ) ?>:</label>

						<select class="widefat crf-sortable-title" id="<?php echo esc_attr( $this->get_field_id('fields') ) . "[data-index]"; ?>[format]" name="<?php echo esc_attr( $this->get_field_name('fields') ) . "[data-index]"; ?>[format]">

						<?php foreach( $this->get_contact_field_format_array() as $k => $v ) : ?>

							<option value="<?php echo esc_attr( $k ); ?>"><?php echo esc_html( $v['label'] ); ?></option>

						<?php endforeach; ?>

						</select>

					</p>

					<p>

						<label for="<?php echo esc_attr( $this->get_field_id('fields') ) . "[data-index]"; ?>[title]"><?php echo esc_html__( "Title", 'semona-extension' ) ?>:</label>

						<input class="widefat crf-sortable-title" type="text" id="<?php echo esc_attr( $this->get_field_id('fields') ) . "[data-index]"; ?>[title]" 

							data-name="<?php echo esc_attr( $this->get_field_name('fields') ) . "[data-index]"; ?>[title]" value="<?php _e( 'New Tab', 'semona-extension' ) ?>" />

					</p>

					<p>

						<label for="<?php echo esc_attr( $this->get_field_id('fields') ) . "[data-index]"; ?>[content]"><?php echo esc_html__( "Content", 'semona-extension' ) ?>:</label>

						<textarea class="widefat" rows="3" id="<?php echo esc_attr( $this->get_field_id('fields') ) . "[data-index]"; ?>[content]" 

							data-name="<?php echo esc_attr( $this->get_field_name('fields') ) . "[data-index]"; ?>[content]"></textarea>

					</p>

				</div>

			</div>

		</div>

		<div class="crf-widget-accordion-tabs crf-sortable ui-sortable">

			<?php

			if( is_array( $instance['fields'] ) ):

				$index = 0; 

				foreach( $instance['fields'] as $field ) { ?>

				<div class="crf-widget-accordion-tab crf-sortable-handle ui-sortable-handle">

					<div class="accordion-tab-title crf-sortable-handle-title">

						<?php _e( 'Field', 'semona-extension' ) ?>: <span><?php echo esc_attr( $field['format'] ) ?></span>

						<div class='delete'><i class='fa fa-close'></i></div>

						<div class='open'><i class='fa fa-caret-down'></i></div>

					</div>

					<div class="crf-sortable-content-wrapper">

						<p>

							<label for="<?php echo esc_attr( $this->get_field_id('fields') ) . "[$index]"; ?>[format]"><?php echo esc_html__( "Field Format", 'semona-extension' ) ?>:</label>

							<select class="widefat crf-sortable-title" id="<?php echo esc_attr( $this->get_field_id('fields') ) . "[$index]"; ?>[format]" name="<?php echo esc_attr( $this->get_field_name('fields') ) . "[$index]"; ?>[format]">

							<?php foreach( $this->get_contact_field_format_array() as $k => $v ) : ?>

								<option value="<?php echo esc_attr( $k ); ?>"<?php if ( $k == $field['format'] ) : ?> selected="selected"<?php endif; ?>><?php echo esc_html( $v['label'] ); ?></option>

							<?php endforeach; ?>

							</select>

						</p>

						<p>

							<label for="<?php echo esc_attr( $this->get_field_id('fields') ) . "[$index]"; ?>[title]"><?php echo esc_html__( "Title", 'semona-extension' ) ?>:</label>

							<input class="widefat" type="text" id="<?php echo esc_attr( $this->get_field_id('fields') ) . "[$index]"; ?>[title]" 

								name="<?php echo esc_attr( $this->get_field_name('fields') ) . "[$index]"; ?>[title]" value="<?php echo esc_attr( $field['title'] ); ?>" />

						</p>

						<p>

							<label for="<?php echo esc_attr( $this->get_field_id('fields') ) . "[$index]"; ?>[content]"><?php echo esc_html__( "Content", 'semona-extension' ) ?>:</label>

							<textarea class="widefat" rows="3" id="<?php echo esc_attr( $this->get_field_id('fields') ) . "[$index]"; ?>[content]" 

								name="<?php echo esc_attr( $this->get_field_name('fields') ) . "[$index]"; ?>[content]"><?php echo esc_attr( $field['content'] ); ?></textarea>

						</p>

					</div>

				</div>

				<?php 

					$index++;

				}

			endif;

			?>

		</div>

	<?php

	}

}

