<?php



/*

 * Enqueue Styles and Scripts required for shortcodes.

 */

function sm_enqueue_scripts_styles() {

	wp_enqueue_style(

		'sm-shortcodes', 

		SM_PLUGIN_URL . '/assets/css/style.css'

	);



	sm_iconpicker_frontend_enqueue_css();



	

	//wp_deregister_script( 'jquery-ui-tabs' );

	wp_register_script( 

		'sm-jquery-ui-tabs', 

		SM_PLUGIN_URL . '/assets/js/frontend/jquery-ui-sm_tabs.js', 

		array('jquery-ui-core', 'jquery-ui-widget'),

		false,

		true

	);



	//wp_deregister_script( 'jquery_ui_tabs_rotate' );

	wp_register_script( 

		'sm-jquery-ui-tabs-rotate', 

		SM_PLUGIN_URL . '/assets/js/frontend/jquery-ui-tabs-rotate.js', 

		array(

			'jquery',

		),

		false,

		true

	);



	wp_enqueue_script( 

		'caroufredsel', 

		SM_PLUGIN_URL . '/assets/js/frontend/jquery.carouFredSel-6.2.1-packed.js', 

		array( 'jquery' ),

		false,

		true

	);



	wp_enqueue_script( 

		'imagesLoaded', 

		SM_PLUGIN_URL . '/assets/js/frontend/imagesloaded-3.1.8.min.js'

	);



	// Dequeue waypoint 2 of visual composer, and use our waypoint 3.

	//wp_deregister_script( 'waypoints' );

	wp_register_script( 

		'waypoints4', 

		SM_PLUGIN_URL . '/assets/js/frontend/waypoints.js',

		array( 'jquery' ),

		'4.0.0',

		true

	);

	wp_enqueue_script( 'waypoints' );



	wp_register_script( 

		'progressCircle', 

		SM_PLUGIN_URL . '/assets/js/progress-circle/ProgressCircle.js',

		array(),

		false,

		true

	);

	wp_register_script( 

		'sm_pie', 

		SM_PLUGIN_URL . '/assets/js/frontend/jquery.sm_chart.js', 

		array(

			'jquery',

			'progressCircle',

		),

		false,

		true

	);

	wp_register_script( 

		'jquery.knob', 

		SM_PLUGIN_URL . '/assets/js/frontend/jquery.knob.min.js', 

		array( 'jquery'	),

		false,

		true

	);

	wp_enqueue_style( 'flexslider', 

		SM_PLUGIN_URL . '/assets/vendor/flexslider-2.5.0/flexslider.css' );

	wp_enqueue_script( 'flexslider', 

		SM_PLUGIN_URL . '/assets/vendor/flexslider-2.5.0/jquery.flexslider-min.js', 

		array( 'jquery' ), 

		false,

		true

	);

	wp_enqueue_script(

		'semona-plugins',

		SM_PLUGIN_URL . '/assets/js/frontend/plugins.js', 

		array( 'jquery' ),

		false,

		true

	);

	wp_enqueue_script( 

		'sm-plugin-functions', 

		SM_PLUGIN_URL . '/assets/js/frontend/functions.js', 

		array( 'jquery', 'waypoints' ),

		false,

		true

	);



	wp_register_style(

		'multiscroll', 

		SM_PLUGIN_URL . '/assets/vendor/multiscroll/jquery.multiscroll.css' 

	);

	wp_register_script(

		'multiscroll', 

		SM_PLUGIN_URL . '/assets/vendor/multiscroll/jquery.multiscroll.js',

		array( 'jquery' ),

		false,

		true

	);



	$map_api = 'http' . ( ( is_ssl() ) ? 's' : '' ) . '://maps.googleapis.com/maps/api/js?sensor=false&amp;language=' . substr( get_locale(), 0, 2 ) . '&amp;key=' . (function_exists( 'crf_get_theme_mod_value' ) ? crf_get_theme_mod_value( 'gmap-api-key' ) : '');

	wp_register_script( 

		'google-maps-api', 

		$map_api, 

		array()

	);

	

	wp_register_script( 

		'google-maps-infobox', 

		SM_PLUGIN_URL . '/assets/vendor/google-infobox/google-infobox.js', 

		array()

	);



	wp_register_script( 

		'sm-gmaps', 

		SM_PLUGIN_URL . '/assets/js/frontend/jquery.sm-gmaps.js',

		array( 'jquery' )

	);



	$gmap_vars = array(

		'gmap_ajax'					=> admin_url( 'admin-ajax.php' ),

		'gmap_ajax_nonce'			=> wp_create_nonce( 'sm_admin_ajax' ),

	);

	wp_localize_script( 'sm-gmaps', 'sm_gmap_vars', $gmap_vars );

	wp_enqueue_script( 'sm-gmaps' );



	wp_register_script(

		'flipclock', 

		SM_PLUGIN_URL . '/assets/vendor/flipclock/flipclock.js',

		array( 'jquery' ),

		false,

		true

	);

	wp_register_style(

		'flipclock', 

		SM_PLUGIN_URL . '/assets/vendor/flipclock/flipclock.css'

	);

}

add_action( 'wp_enqueue_scripts', 'sm_enqueue_scripts_styles', 11 );



function sm_admin_enqueue_scripts_styles() {

	wp_enqueue_style(

		'sm-ext-admin-css',

		SM_PLUGIN_URL . '/assets/css/admin.css'

	);



	sm_iconpicker_backend_enqueue_css();



	wp_enqueue_script( 

		'sm-composer-functions', 

		SM_PLUGIN_URL . '/assets/js/backend/composer-custom-views.js', 

		array( 'jquery', 'vc_accordion_script', 'vc-backend-min-js' ),

		false,

		true

	);

	wp_enqueue_script(

		'jquery-livequery', 

		SM_PLUGIN_URL . '/assets/js/backend/jquery.livequery.min.js'

	);

}

add_action( 'admin_enqueue_scripts', 'sm_admin_enqueue_scripts_styles' );



function sm_iconpicker_frontend_enqueue_css() {

	wp_deregister_style( 'font-awesome' );



	$icon_list = sm_get_icon_list();

	foreach ($icon_list as $icon_info) {

		wp_register_style( 

			$icon_info['handle'], // Handle

			$icon_info['src'] // URL

		);

	}

}



function sm_iconpicker_backend_enqueue_css() {

	wp_deregister_style( 'font-awesome' );

	//wp_deregister_style( 'vc_typicons' );

	//wp_deregister_style( 'vc_entypo' );



	$icon_list = sm_get_icon_list();

	foreach ($icon_list as $icon_info) {

		wp_enqueue_style( 

			$icon_info['handle'], // Handle

			$icon_info['src'] // URL

		);

	}

}