<?php
$icon_list = sm_get_icon_list();

$type = current( array_keys( $icon_list ) );
if ( !empty( $param['settings']['type'] ) ) {
	$type = $param['settings']['type'];
}

$icons_per_page = 100;
if ( !empty( $param['settings']['iconsPerPage'] ) ) {
	$icons_per_page = $param['settings']['iconsPerPage'];
}

$emptyIcon = false;
if ( !empty( $param['settings']['emptyIcon'] ) ) {
	$emptyIcon = $param['settings']['emptyIcon'];
}

?>
<div class="sm-iconpicker-wrapper">
	<select class="crsg-param-value crsg-block-element sm-iconpicker" data-param-name="<?php echo esc_attr( $param['param_name'] ); ?>" data-icons-per-page="<?php echo esc_attr( $icons_per_page ); ?>" data-empty-icon="<?php echo esc_attr( $emptyIcon ); ?>">
	<?php 
	foreach( $icon_list[$type]['icons'] as $group => $icons ) {
		if ( ! is_array( $icons ) || ! is_array( current( $icons ) ) ) {
			$class_key = key( $icons );
			echo '<option value="' . esc_attr( $class_key ) . '">' . esc_html( current( $icons ) ) . '</option>';
		} else {
			echo '<optgroup label="' . esc_attr( $group ) . '">';
			foreach ( $icons as $key => $label ) {
				$class_key = key( $label );
				echo '<option value="' . esc_attr( $class_key ) . '">' . esc_html( current( $label ) ) . '</option>';
			}
			echo '</optgroup>';
		}
	}
	?>
	</select>
</div>