"use strict";

tinymce.PluginManager.add( 'crsg_button', function( ed, url ) {
	
	ed.addCommand( "crsgPopup", function ( a, params ) {
		var popup = 'shortcode-generator';
		if( typeof params != 'undefined' && params.identifier ) {
			popup = params.identifier;
		}
		tb_show( "Semona Shortcodes", ajaxurl + "?action=crsg_popup&popup=" + popup );
	} );

	ed.addButton( 'crsg_button', {
		icon: 'tp-palmtree',
		cmd: 'crsgPopup'
	} );
	
} );

( function( $, window, undefined ) {
	
	var current_shortcode = '';

	/* Dependency implementation */
	function check_dependency() {
		$( '.crsg-shortcode-params.active' ).find( '.crsg-param-section' ).each( function() {
			var $element = $(this);
			var data_dep = $element.data( 'dependency' );
			if( data_dep ) {
				var show = true;
				try {
					var dep_element_input = $element.parent().find( '.crsg-param-value[data-param-name="' + data_dep.element + '"]' );
					var dep_element_value = dep_element_input.val();
					var dep_element_section = dep_element_input.closest( '.crsg-param-section' );
					if( !dep_element_section.is( ':visible' ) ) {
						show = false;
					} else if( data_dep.not_empty && !dep_element_value ) {
						show = false;
					} else if( data_dep.value ) {
						if( $.inArray( dep_element_value, data_dep.value ) == -1 ) {
							show = false;
						}
					} else if( data_dep.value_not_equal_to ) {
						if( $.inArray( dep_element_value, data_dep.value_not_equal_to ) > -1 ) {
							show = false;
						}
					}
				} catch(e) {}
				if( show ) {
					$element.show();
				} else {
					$element.hide();
				}
			}
		} );
	}
	$( 'body' ).on( 'change', '.crsg-param-value', function() {
		check_dependency();
	} );

	/* Left-side shortcode link */
	$( 'body' ).on( 'click', '#crsg-popup .crsg-shortcode-link', function() {
		var $this = $(this);
		var code = $this.data( 'code' );
		var $new_panel = $( '.crsg-shortcode-' + code );
		$( '#crsg-popup .crsg-body' ).children( '.crsg-shortcode-params' ).removeClass( 'active' ).css( 'display', 'none' );
		$new_panel.addClass( 'active' ).css( 'display', 'block' );
		if( $new_panel.data( 'initialized' ) != 'true' ) {
			$new_panel.data( 'initialized', 'true' );
			// For asynchronous loading due to large data.
			setTimeout( function() {
				/* Control - Color picker */
				$new_panel.find( '.crsg-param-colorpicker' ).wpColorPicker();

				/* Control - Icon Picker */
				$new_panel.find( '.sm-iconpicker' ).each( function() {
					$( this ).fontIconPicker( {
						iconsPerPage: $( this ).data( 'iconsPerPage' ),
						emptyIcon: $( this ).data( 'emptyIcon' )
					} );
				} );
			}, 50 );
		}

		current_shortcode = code;
		
		check_dependency();
		
		$(this).siblings( '.crsg-shortcode-link' ).removeClass( 'active' );
		$(this).addClass( 'active' );
		
		return false;
	} );
	
	function compile_param_groups( $container ) {
		var all_args = [];
		$container.find( '.crsg-param-group:not(.prototype)' ).each( function() {
			var $param_group = $(this);
			var args = {};
			$param_group.find( '.crsg-param-section' ).each( function() {
				var $param_group_container = $(this).find( '.crsg-param-group-container' );
				if( $param_group_container.length > 0 ) {
					args[$param_group_container.data( 'param-name' )] = compile_param_groups( $param_group_container );
				} else {
					var $element = $(this).find( '.crsg-param-value' );
					if( $element.length > 0 ) {
						var value = $element.val();
						if( value != '' ) {
							args[$element.data( 'param-name' )] = value;
						}
					}
				}
			} );
			all_args[all_args.length] = args;
		} );
		return all_args;
	}
	
	/* Insert shortcode */
	$( 'body' ).on( 'click', '#crsg-insert-shortcode-button', function() {
		if( current_shortcode != '' ) {
			var output = '[';
			var content = '';
			output += current_shortcode;
			$( '#crsg-popup .crsg-shortcode-params.active > .crsg-param-section:visible' ).each( function() {
				var $param_group_container = $(this).find( '.crsg-param-group-container' );
				if( $param_group_container.length > 0 ) {
					var compiled_value = encodeURI( JSON.stringify( compile_param_groups( $param_group_container ) ) );
					output += ( ' ' + $param_group_container.data( 'param-name' ) + '="' + compiled_value + '"' );
				} else {
					var $element = $(this).find( '.crsg-param-value' );
					if( $element.length > 0 ) {
						var value = $element.val();
						if( value != '' ) {
							if( $element.data( 'param-name' ) == 'content' ) {
								content = value;
							} else {
								output += ( ' ' + $element.data( 'param-name' ) + '="' + value + '"' );
							}
						}
					}
				}
			} );
			output += ']';
			if( content != '' ) {
				output += content;
				output += '[/';
				output += current_shortcode;
				output += ']';
			}
			if( window.tinyMCE ) {
				window.tinyMCE.activeEditor.execCommand( 'mceInsertContent', false, output );
			}
			tb_remove();
		}
		return false;
	} );

	/* Control - checkbox */
	$( 'body' ).on( 'change', '.crsg-param-checkbox', function() {
		var $this = $(this);
		var value = $this.data( 'value' );
		if( $this.is( ':checked' ) ) {
			$(this).siblings( '.crsg-param-value' ).val( value ).trigger( 'change' );
		} else {
			$(this).siblings( '.crsg-param-value' ).val( '' ).trigger( 'change' );
		}
	} );
	
	/* Attach Image */
	$( 'body' ).on( 'click', '.crsg-attach-image .crsg-image-block', function() {
		var $this = $(this);
		var custom_uploader;
		if( custom_uploader ) {
	        custom_uploader.open();
	        return;
	    }
		custom_uploader = wp.media.frames.file_frame = wp.media( {
	        title: 'Choose Image',
	        button: {
	            text: 'Choose Image'
	        },
	        multiple: false
	    } );
	    custom_uploader.on( 'select', function() {
	    	var selection = custom_uploader.state().get( 'selection' );
	        selection.map( function( attachment ) {
		        attachment = attachment.toJSON();
		        $this.siblings( '.crsg-image-thumb' ).show().find( 'img' ).attr( 'src', attachment.sizes['thumbnail'].url );
		        $this.siblings( '.crsg-param-value' ).val( attachment.id );
	        } );
	    } );
	    custom_uploader.open();
	    return false;
	} );
	$( 'body' ).on( 'click', '.crsg-attach-image .crsg-image-thumb i', function() {
		$(this).closest( '.crsg-image-thumb' ).hide().siblings( '.crsg-param-value' ).val( '' );
		return false;
	} );
	
	/* Attach Images */
	$( 'body' ).on( 'click', '.crsg-attach-images .crsg-image-block', function() {
		var $this = $(this);
		var $container = $this.parent();
		var custom_uploader;
		if (custom_uploader) {
	        custom_uploader.open();
	        return;
	    }
		custom_uploader = wp.media.frames.file_frame = wp.media( {
	        title: 'Choose Image',
	        button: {
	            text: 'Choose Image'
	        },
	        multiple: true
	    } );
	    custom_uploader.on('select', function() {
	    	var selection = custom_uploader.state().get( 'selection' );
	    	var img_ids = $container.find( '.crsg-param-value' ).val();
	        selection.map( function( attachment ) {
		        attachment = attachment.toJSON();
		        var $new_img = $container.find( '.crsg-prototype' ).clone().removeClass( 'crsg-prototype' );
		        $new_img.find( 'img' ).attr( 'src', attachment.sizes['thumbnail'].url );
		        $new_img.insertBefore( $this ).attr( 'data-id', attachment.id ).show();
		        if( img_ids == '' ) {
		        	img_ids = attachment.id;
		        } else {
		        	img_ids += ( ', ' + attachment.id );
		        }
		        $container.find( '.crsg-param-value' ).val( img_ids );
	        } );
	    } );
	    custom_uploader.open();
	    return false;
	} );
	$( 'body' ).on( 'click', '.crsg-attach-images .crsg-image-thumb i', function() {
		var new_ids = '';
		var $element = $(this).closest( '.crsg-image-thumb' );
		$element.siblings( '.crsg-image-thumb:not(.crsg-prototype)' ).each( function() {
			var id = $(this).data( 'id' );
			if( new_ids == '' ) {
				new_ids = id;
	        } else {
	        	new_ids += ( ', ' + id );
	        }
		} );
		$element.siblings( '.crsg-param-value' ).val( new_ids );
		$element.remove();
		return false;
	} );
	
	/* Param group controls */
	$( 'body' ).on( 'click', '.crsg-param-group-container .crsg-param-group-control', function() {
		var $this = $(this);
		var $param_group = $this.closest( '.crsg-param-group' );
		if( $this.hasClass( 'move' ) ) {
			
		} else if( $this.hasClass( 'toggle' ) ) {
			if( $param_group.hasClass( 'closed' ) ) {
				$param_group.removeClass( 'closed' );
				$param_group.find( '.crsg-param-group-body' ).slideDown( 300 );
			} else {
				$param_group.addClass( 'closed' );
				$param_group.find( '.crsg-param-group-body' ).slideUp( 300 );
			}
			return false;
		} else if( $this.hasClass( 'clone' ) ) {
			var $cloned = $param_group.clone();
			$cloned.insertAfter( $param_group );
			return false;
		} else if( $this.hasClass( 'delete' ) ) {
			$param_group.remove();
			return false;
		}
	} );
	$( 'body' ).on( 'click', '.crsg-param-group-container .crsg-param-group-add', function() {
		var $this = $(this);
		var $container = $this.closest( '.crsg-param-group-container' );
		$container.find( '.crsg-param-group.prototype' ).clone().removeClass( 'prototype' ).appendTo( $container.find( '.crsg-param-groups' ) ).show();
		return false;
	} );

	$( '#crsg-popup' ).livequery( function() {

		/* Add our class to modal dialog parts so that we can apply styles */
		$( '#crsg-popup' ).closest( '#TB_window' ).addClass( 'crsg-popup-wrapper' ).siblings( '#TB_overlay' ).addClass( 'crsg-popup-overlay-bg' );
		
		/* Adjusting dialog size */
		$( '.crsg-popup-wrapper' ).find( '#TB_ajaxContent' ).css( 'height', '750px' );
		$( '.crsg-popup-wrapper' ).css( 'height', 'auto' );
		$( '#crsg-popup' ).css( 'visibility', 'visible' );

		/* Param group sortable */
		$( '.crsg-param-groups' ).sortable( {
			handle: '.crsg-param-group-control.move'
		} );
		
		/* ID assigning */
		$( '#crsg-popup .sm-el_id' ).each( function() {
			var el_id = ( 'element-' + ( + new Date() ) + '-' + Math.floor( Math.random() * 11 ) );
			$( this ).find( 'input.crsg-param-value' ).val( el_id );
		} );
		$( '#crsg-popup .sm-tab_id' ).each( function() {
			if ( typeof window.sm_tabs_count === 'undefined' )
				window.sm_tabs_count = 1;
			var tab_id = ( + new Date() + '-' + ( window.sm_tabs_count ++ ) + '-' + Math.floor( Math.random() * 11 ) );
			$( this ).find( 'input.crsg-param-value' ).val( tab_id );
			$( this ).find( 'label.crsg-param-label' ).html( tab_id );
		} );
		
		$('select.crsg-autocomplete').each( function() {
			var $this = $( this ),
				action = 'sm_get_autocomplete_suggestion',
				shortcode = $this.closest( '.crsg-shortcode-params' ).data( 'shortcodeBase' ), // get current shortcode?
				param_name = $this.data( 'param-name' );
			var ex_data = 'action=' + action + '&shortcode=' + shortcode + '&param=' + param_name;
			$this.tokenize( {
				datas: window.ajaxurl,
				extraData: ex_data,
				textField: 'label',
				searchParam: 'query'
			} );
		} );
	} );
	
} )( jQuery, window );