<?php



add_action( 'init', 'crf_register_post_type_portfolio' );

function crf_register_post_type_portfolio() {

	

	$slug = 'portfolio-items';

	if( function_exists( 'crf_get_theme_mod_value' ) ) {

		$new_slug = crf_get_theme_mod_value( 'portfolio-slug' );

		if( $new_slug ) {

			$slug = $new_slug;

		}

	}

	register_post_type ( 'crf_portfolio', array (

			'labels' => array (

					'name' => esc_html__( 'Portfolio', 'semona-extension' ),

					'singular_name' => esc_html__( 'Portfolio', 'semona-extension' ) 

			),

			'public' => true,

			'publicly_queryable' => true,

			'rewrite' => array (

					'slug' => $slug

			),

			'supports' => array (

					'title',

					'editor',

					'excerpt',

					'author',

					'thumbnail',

					'comments',

					'revisions',

					'custom-fields',

					'page-attributes',

					'post-formats' 

			),

			'can_export' => true 

	) );

	

	register_taxonomy(  'post_format', 'crf_portfolio', array(

			'public' => true,

			'hierarchical' => false,

			'labels' => array(

				'name' => _x( 'Format', 'post format', 'semona' ),

				'singular_name' => _x( 'Format', 'post format', 'semona' ),

			),

			'query_var' => true,

			'rewrite' => 'crf_portfolio_post_format',

			'show_ui' => false,

			'_builtin' => true,

			'show_in_nav_menus' => false,

	) );

	

	register_taxonomy ( 'portfolio_category', 'crf_portfolio', array (

			'hierarchical' => true,

			'label' => esc_html__( 'Portfolio Categories', 'semona-extension' ),

			'query_var' => true,

			'rewrite' => true,

	) );

	register_taxonomy ( 'portfolio_skills', 'crf_portfolio', array (

			'hierarchical' => true,

			'label' => esc_html__( 'Portfolio Skills', 'semona-extension' ),

			'query_var' => true,

			'rewrite' => true 

	) );

	register_taxonomy ( 'portfolio_tags', 'crf_portfolio', array (

			'hierarchical' => false,

			'label' => esc_html__( 'Portfolio Tags', 'semona-extension' ),

			'query_var' => true,

			'rewrite' => true 

	) );

	

}

