/* =========================================================

 * jquery.sm_chart.js v1.0

 * =========================================================

 * Copyright 2015 Theme-Paradise

 *

 * JQuery Chart plugin for Semona

 * ========================================================= */

(function($){

	/**

	 * Pie chart animated.

	 * @param element - DOM element

	 * @param options - settings object.

	 * @constructor

	 */

	var SMChart = function(element, options) {

		this.el = element;

		this.$el = $(this.el);

		this.options = $.extend({

			color: '',

			headColor: '#fff',

			units: '',

			label_selector: '.sm_pie_chart_value',

			back_selector: '.sm_pie_chart_back',

			responsive: true

		}, options);

		this.init();

	};

	SMChart.prototype = {

		constructor: SMChart,

		_progress_v: 0,

		animated: false,

		init: function() {

			this.setupColor();

			this.value = this.$el.data('pie-value')/100;

			this.headColor = this.options.headColor;

			this.label_value = this.$el.data('pie-label-value') || this.$el.data('pie-value');

			this.back_thickness = this.$el.data('back-thickness');

			this.$wrapper = $('.sm_pie_wrapper', this.$el);

			this.$label = $(this.options.label_selector, this.$el);

			this.$back = $(this.options.back_selector, this.$el);

			this.$canvas = this.$el.find('canvas');

			this.draw();

			this.setWayPoint();

			if(this.options.responsive === true) this.setResponsive();



		},

		setupColor: function() {

			if(typeof this.options.color === 'string' && 

                ( this.options.color.match(/^rgba?\([^\)]+\)/) || this.options.color.match(/^#?[A-Za-z0-9]{3}/) || this.options.color.match(/^#?[A-Za-z0-9]{6}/) ) ) {

				this.color = this.options.color;

			} else {

				this.color = '#4396e6';

			}

		},

		setResponsive: function() {

			var that = this;

			$(window).resize(function(){

				if(that.animated === true) that.circle.stop();

				that.draw(true);

			});

		},

		draw: function(redraw) {

			var w = this.$el.addClass('sm_ready').width(),

				border_w = 3,

				margin_w = 8,

				radius;

				//this.back_thickness / 2

			if(!w) w = this.$el.parents(':visible').first().width();

			w -= (this.back_thickness - border_w) / 2;

			back_w = w - margin_w * 2;

			radius = w/2 - margin_w - (this.back_thickness) / 2 - border_w / 2;

			this.$wrapper.css({"width" : w + "px"});

			this.$label.css({"width" : w, "height" : w, "font-size" : parseInt( w / 4 ) });

			this.$back.css({"width" : back_w, "height" : back_w, "margin" : margin_w});

			this.$canvas.attr({"width" : w + "px", "height" : w + "px"});

			//this.$el.addClass('sm_ready');

			this.circle = new ProgressCircle({

				canvas: this.$canvas.get(0),

				minRadius: radius,

				arcWidth: border_w

			});

			if(redraw === true && this.animated === true) {

				this._progress_v = this.value;

				this.circle.addEntry({

					fillColor: this.color,

					headColor: this.headColor,

					progressListener: $.proxy(this.setProgress, this)

				}).start();

			}

		},

		setProgress: function() {

			if (this._progress_v >= this.value) {

				this.circle.stop();

				var val = this.label_value + this.options.units;

				this.$label.html('<span class="value">' + val + '</span>');

				return this._progress_v;

			}

			this._progress_v += 0.005;

			var label_value = this._progress_v/this.value*this.label_value;

			var val = Math.round(label_value) + this.options.units;

			this.$label.html('<span class="value">' + val + '</span>');

			return this._progress_v;

		},

		animate: function() {

			if(this.animated !== true) {

				this.animated = true;

				this.circle.addEntry({

					fillColor: this.color,

					headColor: this.headColor,

					progressListener: $.proxy(this.setProgress, this)

				}).start(5);

			}

		},

		setWayPoint: function() {

			if (typeof $.fn.waypoint !== 'undefined') {

				this.$el.waypoint($.proxy(this.animate, this), { offset: '85%' });

			} else {

				this.animate();

			}

		}

	};

	/**

	 * jQuery plugin

	 * @param option - object with settings

	 * @return {*}

	 */

	$.fn.smChart = function(option, value) {

		return this.each(function () {

			var $this = $(this),

				data = $this.data('sm_chart'),

				options = typeof option === 'object' ? option : {

					color: $this.data('pie-color'),

					headColor: $this.data('head-color'),

					units: $this.data('pie-units')

				};

			if (typeof option == 'undefined') $this.data('sm_chart', (data = new SMChart(this, options)));

			if (typeof option == 'string') data[option](value);

		});

	};

	/**

	 * Allows users to rewrite function inside theme.

	 */

	if ( typeof window['sm_pieChart'] !== 'function' ) {

		window.sm_pieChart = function() {

			$('.sm_pie_chart:visible').smChart();

		}

	}



})(window.jQuery);